<?php
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/admin/config.php';

$promo  = isset($_POST['promo_code']) ? trim($_POST['promo_code']) : '';
$prize  = isset($_POST['prize_amount']) ? (int)$_POST['prize_amount'] : 0;

if ($promo === '' || $prize <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Missing promo or prize.'
    ]);
    exit;
}

$ip  = $_SERVER['REMOTE_ADDR'] ?? '';
$ua  = $_SERVER['HTTP_USER_AGENT'] ?? '';

try {
    $stmt = $pdo->prepare("
        INSERT INTO promo_usage (promo_code, prize_amount, ip_address, user_agent)
        VALUES (?, ?, ?, ?)
    ");
    $stmt->execute([$promo, $prize, $ip, $ua]);

    echo json_encode([
        'success' => true
    ]);
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'message' => 'DB error.'
    ]);
}
