<?php
// Load config from admin/config.php
require __DIR__ . '/admin/config.php';

$stmt = $pdo->prepare("SELECT * FROM site_config WHERE id = 1 LIMIT 1");
$stmt->execute();
$config = $stmt->fetch(PDO::FETCH_ASSOC) ?: [];

$claimPrizeUrl = $config['claim_prize_url'] ?? '#';
$logoUrl       = $config['logo_url'] ?? 'logo.jpg';
$promoHelpText = $config['promo_help_text'] ?? 'Please field your promocode to start this game';
$siteName     = $config['site_name'] ?? 'Angpao Rain';
$maintenanceMode = (int)($config['maintenance_mode'] ?? 0);
$maintenanceMsg  = $config['maintenance_message'] ?? 'We are under maintenance. Please try again later.';

?>

<?php if ($maintenanceMode === 1): ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Maintenance – <?php echo htmlspecialchars($siteName); ?></title>
    <style>
        body {
            margin:0;
            padding:0;
            min-height:100vh;
            display:flex;
            align-items:center;
            justify-content:center;
            background:#000;
            color:#f9fafb;
            font-family:Arial,sans-serif;
        }
        .box {
            text-align:center;
            max-width:420px;
            padding:24px 26px;
            border-radius:16px;
            background:radial-gradient(circle at top,#3b0000 0%,#120000 60%,#000 100%);
            box-shadow:0 0 24px rgba(255,0,0,0.6);
            border:1px solid rgba(255,255,255,0.1);
        }
        .logo-circle {
            width:80px;height:80px;
            margin:0 auto 12px;
            border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            box-shadow:0 0 18px rgba(255,193,7,0.9);
            overflow:hidden;
        }
        .logo-circle img{
            max-width:80%;max-height:80%;border-radius:999px;
        }
        h1{
            font-size:20px;margin-bottom:6px;
        }
        p{
            font-size:14px;color:#e5e7eb;opacity:0.9;
        }
    </style>
</head>
<body>
<div class="box">
    <div class="logo-circle">
        <img src="<?php echo htmlspecialchars($logoUrl); ?>" alt="Logo">
    </div>
    <h1><?php echo htmlspecialchars($siteName); ?></h1>
    <p><?php echo nl2br(htmlspecialchars($maintenanceMsg)); ?></p>
</div>

<!-- =========================
     BASIC FRONTEND "SECURITY"
     ========================= -->
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', function (e) {
        e.preventDefault();
    });

    // Disable some common devtools / view-source keys
    document.addEventListener('keydown', function (e) {
        // F12
        if (e.key === 'F12') {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }

        // Ctrl+Shift+I / J / C
        if (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C')) {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }

        // Ctrl+U (view source), Ctrl+S (save)
        if (e.ctrlKey && (e.key === 'U' || e.key === 'S')) {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }
    });
</script>
</body>
</html>
<?php exit; endif; ?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($siteName); ?></title>

    <style>
        body {
            margin: 0;
            padding: 0;
            overflow: hidden;
            background: #000000; /* black */
            font-family: Arial, sans-serif;
            position: relative;

            /* disable text selection globally */
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        /* ===== TOP LOGO WITH ANIMATION ===== */
        #topLogo {
            width: 100%;
            text-align: center;
            margin-top: 20px;
            z-index: 10;
            position: relative;
        }

        #promoInput {
            -webkit-user-select: text;
            -moz-user-select: text;
            -ms-user-select: text;
            user-select: text;
        }

        .top-logo-circle {
            width: 110px;
            height: 110px;
            margin: 0 auto;
            border-radius: 999px;
            background: radial-gradient(circle, #ffeb3b, #ff9800, #bf360c);
            box-shadow: 0 0 18px rgba(255,193,7,0.9), 0 0 32px rgba(255,87,34,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            animation: logoFloat 3s ease-in-out infinite, logoGlow 2.4s ease-in-out infinite alternate;
        }

        .top-logo-circle img {
            max-width: 80%;
            max-height: 80%;
            border-radius: 999px;
            display: block;
            filter: drop-shadow(0 0 6px rgba(0,0,0,0.5));
        }

        /* light sweep on logo */
        .top-logo-circle::before {
            content: "";
            position: absolute;
            top: -120%;
            left: -60%;
            width: 70%;
            height: 260%;
            background: linear-gradient(
                120deg,
                rgba(255,255,255,0.0),
                rgba(255,255,255,0.45),
                rgba(255,255,255,0.0)
            );
            transform: rotate(25deg);
            animation: logoShine 2.8s infinite;
            pointer-events: none;
        }

        @keyframes logoFloat {
            0%   { transform: translateY(0); }
            50%  { transform: translateY(-6px); }
            100% { transform: translateY(0); }
        }

        @keyframes logoGlow {
            0% {
                box-shadow:
                    0 0 12px rgba(255,193,7,0.7),
                    0 0 22px rgba(255,87,34,0.4);
            }
            100% {
                box-shadow:
                    0 0 20px rgba(255,235,59,1),
                    0 0 36px rgba(255,111,0,0.9);
            }
        }

        @keyframes logoShine {
            0%   { transform: translateX(-150%) rotate(25deg); opacity: 0; }
            15%  { opacity: 1; }
            100% { transform: translateX(160%) rotate(25deg); opacity: 0; }
        }

        /* ===== GAME TITLE UNDER LOGO ===== */
        #gameTitle {
            text-align: center;
            margin-top: 8px;
            font-size: 26px;
            letter-spacing: 3px;
            text-transform: uppercase;
            color: #ffeb3b;
            text-shadow: 0 0 8px rgba(255,235,59,0.8), 0 0 18px rgba(255,87,34,0.8);
            opacity: 0;
            transform: translateY(10px);
        }

        #gameTitle.show-title {
            animation: gameTitleIn 0.8s ease-out forwards;
        }

        @keyframes gameTitleIn {
            0% {
                opacity: 0;
                transform: translateY(10px) scale(0.95);
            }
            60% {
                opacity: 1;
                transform: translateY(0) scale(1.05);
            }
            100% {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        /* ===== CENTER COUNTDOWN ===== */
        #countdown {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0.2);
            font-size: 120px;
            font-weight: bold;
            color: #ffeb3b;
            text-shadow:
                0 0 16px rgba(255,235,59,1),
                0 0 32px rgba(255,193,7,0.9),
                0 0 48px rgba(255,87,34,0.7);
            opacity: 0;
            pointer-events: none;
            z-index: 15;
        }

        #countdown.show {
            animation: countdownPop 1s ease-out forwards;
        }

        @keyframes countdownPop {
            0% {
                opacity: 0;
                transform: translate(-50%, -50%) scale(0.2);
            }
            40% {
                opacity: 1;
                transform: translate(-50%, -50%) scale(1.2);
            }
            100% {
                opacity: 0;
                transform: translate(-50%, -50%) scale(1);
            }
        }

        /* ===== METEOR (BACKGROUND ONLY) ===== */
        .meteor {
            position: absolute;
            top: 0;
            width: 2px;
            height: 60px;
            background: linear-gradient(to bottom, rgba(255,80,80,0), rgba(255,0,0,1));
            box-shadow: 0 0 8px rgba(255,0,0,0.7);
            pointer-events: none;
            z-index: 1;
            will-change: transform, opacity;
            transform: translate3d(0, -100vh, 0);
            opacity: 0;
            visibility: hidden;
        }

        @keyframes meteor-fall {
            0% {
                transform: translate3d(0, -100vh, 0);
                opacity: 0;
                visibility: hidden;
            }
            5% {
                visibility: visible;
                opacity: 0;
            }
            20% {
                opacity: 1;
            }
            100% {
                transform: translate3d(0, 110vh, 0);
                opacity: 0;
            }
        }

        /* ===== ANGPAO (CLICKABLE RAIN) ===== */
        .angpao {
            position: absolute;
            width: 70px;
            height: 110px;
            background: #d32f2f;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(255,0,0,0.8);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: gold;
            font-size: 36px;
            font-weight: bold;
            z-index: 5;
            user-select: none;
            will-change: transform;
            transition: transform 0.15s;
        }

        .angpao:hover {
            transform: scale(1.08);
        }

        @keyframes angpao-fall {
            from {
                transform: translate3d(0, -200px, 0);
            }
            to {
                transform: translate3d(0, 100vh, 0);
            }
        }

        /* ===================================== */
        /* POPUP OVERLAY + CENTER ANGPAO         */
        /* ===================================== */

        .overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 20;
            visibility: hidden;
            opacity: 0;
            transition: opacity 0.3s;
        }

        .overlay.show {
            visibility: visible;
            opacity: 1;
        }

        .popup-card {
            background: radial-gradient(circle at top, #3b0000 0%, #120000 60%, #000 100%);
            border-radius: 16px;
            padding: 24px 32px 28px;
            box-shadow: 0 0 25px rgba(255,0,0,0.7);
            text-align: center;
            position: relative;
            width: 320px;
        }

        /* Big center Angpao with effect */
        .popup-angpao {
            width: 120px;
            height: 180px;
            background: #d32f2f;
            border-radius: 14px;
            margin: 0 auto 16px;
            box-shadow: 0 0 25px rgba(255,0,0,0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            color: gold;
            font-size: 64px;
            font-weight: bold;
            position: relative;
            overflow: hidden;
            animation: pulse 1.3s infinite ease-in-out;
        }

        /* subtle light sweep on popup Angpao */
        .popup-angpao::before {
            content: "";
            position: absolute;
            top: -100%;
            left: -50%;
            width: 80%;
            height: 250%;
            background: linear-gradient(
                120deg,
                rgba(255,255,255,0.05),
                rgba(255,255,255,0.4),
                rgba(255,255,255,0.05)
            );
            transform: rotate(25deg);
            animation: shine 2.2s infinite;
        }

        @keyframes pulse {
            0%   { transform: scale(1); }
            50%  { transform: scale(1.06); }
            100% { transform: scale(1); }
        }

        @keyframes shine {
            0%   { transform: translateX(-150%) rotate(25deg); }
            100% { transform: translateX(150%) rotate(25deg); }
        }

        .popup-text {
            color: #ffebee;
            font-size: 16px;
            margin-bottom: 14px;
        }

        .popup-result {
            color: #ffeb3b;
            font-size: 20px;
            font-weight: bold;
            margin-top: 10px;
            min-height: 24px;
        }

        .btn-open {
            padding: 10px 26px;
            border-radius: 999px;
            border: none;
            outline: none;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            background: linear-gradient(135deg, #ff9800, #ff5722);
            color: #fff;
            box-shadow: 0 0 12px rgba(255,152,0,0.9);
            transition: transform 0.12s, box-shadow 0.12s;
        }

        .btn-open:hover {
            transform: translateY(-1px) scale(1.03);
            box-shadow: 0 0 18px rgba(255,152,0,1);
        }

        .btn-open:active {
            transform: translateY(1px) scale(0.97);
            box-shadow: 0 0 8px rgba(255,152,0,0.7);
        }
    </style>
</head>
<body>

<!-- TOP LOGO -->
<div id="topLogo">
    <div class="top-logo-circle">
        <img src="<?php echo htmlspecialchars($logoUrl); ?>" alt="Logo">
    </div>
</div>

<!-- GAME TITLE (appears when game starts) -->
<div id="gameTitle">
    <?php echo htmlspecialchars($siteName); ?>
</div>

<!-- CENTER COUNTDOWN -->
<div id="countdown"></div>

<!-- PROMOCODE OVERLAY -->
<div id="promoOverlay" class="overlay show">
    <div class="popup-card">
        <div class="top-logo-circle">
            <img src="<?php echo htmlspecialchars($logoUrl); ?>" alt="Logo">
        </div>

        <div class="popup-text" style="font-size:20px; margin-top:10px;">
            Field Promocode
        </div>

        <div class="popup-text" style="opacity:0.8; margin-bottom:20px;">
            <?php echo htmlspecialchars($promoHelpText); ?>
        </div>

        <input id="promoInput" type="text"
               placeholder="Promocode"
               style="
                width: 100%;
                padding: 10px 12px;
                border-radius: 8px;
                border: none;
                outline: none;
                font-size: 16px;
                text-align: center;
                margin-bottom: 14px;
            ">

        <div id="promoError" style="
            color: #ff4d4d;
            font-size: 14px;
            text-align: center;
            margin-top: -10px;
            margin-bottom: 10px;
            height: 18px;
        "></div>

        <button id="startGameBtn" class="btn-open" style="width:100%;">
            Start Game
        </button>
    </div>
</div>

<!-- POPUP OVERLAY (AFTER CLICK ANGPAO) -->
<div id="popupOverlay" class="overlay">
    <div class="popup-card">
        <div class="top-logo-circle">
            <img src="<?php echo htmlspecialchars($logoUrl); ?>" alt="Logo">
        </div>
        <div class="popup-angpao" id="popupAngpao">
            福
        </div>
        <div class="popup-text" id="popupText">
            Click to open Lucky Angpao
        </div>
        <button class="btn-open" id="btnOpen">
            Open
        </button>
        <div class="popup-result" id="popupResult"></div>
    </div>
</div>

<!-- expose claim URL to JS -->
<script>
    const CLAIM_PRIZE_URL = <?php echo json_encode($claimPrizeUrl ?: '#'); ?>;
</script>

<script>
    // GLOBAL STATE
    let promoDone = false;
    let activePromoCode = null;

    const promoOverlay = document.getElementById('promoOverlay');
    const promoInput   = document.getElementById('promoInput');
    const startGameBtn = document.getElementById('startGameBtn');
    const promoError   = document.getElementById('promoError');

    const countdownEl  = document.getElementById('countdown');
    const gameTitle    = document.getElementById('gameTitle');

    // Start countdown 3,2,1 then allow Angpao
    function startCountdown() {
        let count = 3;

        function step() {
            countdownEl.textContent = count;
            countdownEl.classList.remove("show");
            // re-trigger animation
            void countdownEl.offsetWidth;
            countdownEl.classList.add("show");

            if (count > 1) {
                count--;
                setTimeout(step, 1000);
            } else {
                // After last number animation finishes, enable Angpao rain
                setTimeout(() => {
                    countdownEl.textContent = "";
                    countdownEl.classList.remove("show");
                    promoDone = true; // now Angpao can start
                }, 1000);
            }
        }

        step();
    }

    // Check promocode with backend
    startGameBtn.addEventListener("click", async () => {
        let code = promoInput.value.trim();

        if (code === "") {
            promoError.textContent = "Please enter your promocode.";
            return;
        }

        promoError.textContent = "";
        startGameBtn.disabled = true;
        const oldText = startGameBtn.textContent;
        startGameBtn.textContent = "Checking...";

        try {
            const response = await fetch("check_promo.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"
                },
                body: "code=" + encodeURIComponent(code)
            });

            const data = await response.json();

            if (!data.success) {
                promoError.textContent = data.message || "Invalid promocode.";
                startGameBtn.disabled = false;
                startGameBtn.textContent = oldText;
                return;
            }

            // OK, promocode accepted
            activePromoCode = data.code || code.toUpperCase();

            // Hide promo popup, show title & start countdown
            promoOverlay.classList.remove("show");
            gameTitle.classList.add("show-title");
            startCountdown();

        } catch (err) {
            console.error(err);
            promoError.textContent = "Server error. Please try again.";
            startGameBtn.disabled = false;
            startGameBtn.textContent = oldText;
            return;
        }

        startGameBtn.disabled = false;
        startGameBtn.textContent = oldText;
    });
</script>

<script>
    let meteorInterval = null;
    let angpaoInterval = null;
    let popupShown = false;
    let chosenPrize = null;
    let prizeRevealed = false;

    // =========================
    // BACKGROUND METEORS
    // =========================
    function createMeteor() {
        const meteor = document.createElement("div");
        meteor.className = "meteor";

        meteor.style.left = Math.random() * window.innerWidth + "px";

        const height = 40 + Math.random() * 50;
        meteor.style.height = height + "px";

        const duration = 1.8 + Math.random() * 1.2;
        meteor.style.animation = `meteor-fall ${duration}s linear forwards`;

        document.body.appendChild(meteor);

        setTimeout(() => meteor.remove(), duration * 1000);
    }

    meteorInterval = setInterval(createMeteor, 160);

    // =========================
    // ANGPAO RAIN (CLICKABLE)
    // =========================
    function createAngpao() {
        if (popupShown || !promoDone) return; // wait for countdown to finish

        const angpao = document.createElement("div");
        angpao.className = "angpao";
        angpao.textContent = "福";

        angpao.style.left = Math.random() * (window.innerWidth - 70) + "px";

        const duration = 3 + Math.random() * 3;
        angpao.style.animation = `angpao-fall ${duration}s linear forwards`;

        document.body.appendChild(angpao);

        angpao.onclick = () => {
            if (popupShown) return;
            popupShown = true;

            // stop further Angpao rain
            if (angpaoInterval) clearInterval(angpaoInterval);
            document.querySelectorAll('.angpao').forEach(el => el.remove());

            openPopup();
        };

        setTimeout(() => {
            if (angpao.parentNode && !popupShown) {
                angpao.remove();
            }
        }, duration * 1000);
    }

    angpaoInterval = setInterval(createAngpao, 550);

    // =========================
    // POPUP LOGIC
    // =========================
    const popupOverlay = document.getElementById('popupOverlay');
    const popupAngpao  = document.getElementById('popupAngpao');
    const popupText    = document.getElementById('popupText');
    const popupResult  = document.getElementById('popupResult');
    const btnOpen      = document.getElementById('btnOpen');

    function openPopup() {
        popupText.textContent = "Click to open Lucky Angpao";
        popupResult.textContent = "";
        prizeRevealed = false;
        btnOpen.disabled = false;
        btnOpen.textContent = "Open";
        popupOverlay.classList.add('show');
    }

    async function fetchPrizeFromServer() {
        try {
            const response = await fetch('get_prize.php', {
                method: 'GET',
                headers: {
                    'Accept': 'application/json'
                }
            });

            const data = await response.json();

            if (!data.success) {
                console.warn("get_prize.php error:", data.error);
                return null;
            }

            return data.prize;
        } catch (err) {
            console.error("Fetch error:", err);
            return null;
        }
    }

    btnOpen.addEventListener('click', async () => {
        // second click → redirect to claim URL
        if (prizeRevealed) {
            if (CLAIM_PRIZE_URL && CLAIM_PRIZE_URL !== '#') {
                window.location.href = CLAIM_PRIZE_URL;
            }
            return;
        }

        // first click → open Angpao and get prize
        btnOpen.disabled = true;
        btnOpen.textContent = "Opening...";

        // small "open" animation
        popupAngpao.style.animation = 'none';
        void popupAngpao.offsetWidth;
        popupAngpao.style.animation =
            'pulse 0.4s ease-in-out 0s 1, shine 2.2s infinite';

        // ask backend for prize
        const prize = await fetchPrizeFromServer();

        if (prize === null) {
            popupText.textContent = "Oops, something went wrong.";
            popupResult.textContent = "Please try again later.";
            btnOpen.textContent = "Error";
            btnOpen.disabled = false;
            return;
        }

        chosenPrize = prize;

        // log promo + prize to backend
        logResultToServer(activePromoCode, chosenPrize);

        setTimeout(() => {
            popupText.textContent = "Congratulations! Your prize is:";
            popupResult.innerHTML =
                "$" + chosenPrize + " 🎉" +
                "<br><span style='font-size:14px;color:#ffe082;'>Promocode Number: " +
                (activePromoCode || '-') + "</span>";

            prizeRevealed = true;
            btnOpen.disabled = false;
            btnOpen.textContent = "Claim your Prize";
        }, 400);
    });

    async function logResultToServer(promoCode, prizeAmount) {
        try {
            if (!promoCode || !prizeAmount) return;

            await fetch('log_result.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                },
                body:
                    'promo_code=' + encodeURIComponent(promoCode) +
                    '&prize_amount=' + encodeURIComponent(prizeAmount)
            });
            // no need to check response for now
        } catch (e) {
            console.error('log_result error:', e);
        }
    }
</script>

<!-- =========================
     BASIC FRONTEND "SECURITY"
     ========================= -->
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', function (e) {
        e.preventDefault();
    });

    // Disable some common devtools / view-source keys
    document.addEventListener('keydown', function (e) {
        // F12
        if (e.key === 'F12') {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }

        // Ctrl+Shift+I / J / C
        if (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C')) {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }

        // Ctrl+U (view source), Ctrl+S (save)
        if (e.ctrlKey && (e.key === 'U' || e.key === 'S')) {
            e.preventDefault();
            e.returnValue = false;
            return false;
        }
    });
</script>

</body>
</html>
