<?php
header('Content-Type: application/json');

require __DIR__ . '/admin/config.php';

try {
    // Get active prizes with percent > 0
    $stmt = $pdo->query("
        SELECT prize_amount, weight
        FROM win_probabilities
        WHERE is_active = 1 AND weight > 0
        ORDER BY prize_amount ASC
    ");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        echo json_encode([
            'success' => false,
            'error'   => 'NO_ACTIVE_PRIZES'
        ]);
        exit;
    }

    // Total percent (we treat 'weight' as percent)
    $total = 0.0;
    foreach ($rows as $row) {
        $total += (float)$row['weight'];
    }

    if ($total <= 0) {
        echo json_encode([
            'success' => false,
            'error'   => 'TOTAL_PERCENT_ZERO'
        ]);
        exit;
    }

    // Weighted random pick
    $rand = mt_rand() / mt_getrandmax() * $total;
    $current = 0.0;
    $selectedPrize = null;

    foreach ($rows as $row) {
        $current += (float)$row['weight'];
        if ($rand <= $current) {
            $selectedPrize = (int)$row['prize_amount'];
            break;
        }
    }

    if ($selectedPrize === null) {
        // Fallback (should not happen)
        $last = end($rows);
        $selectedPrize = (int)$last['prize_amount'];
    }

    echo json_encode([
        'success' => true,
        'prize'   => $selectedPrize
    ]);
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error'   => 'SERVER_ERROR'
    ]);
}
