<?php
header('Content-Type: application/json');

require __DIR__ . '/admin/config.php';

$code = $_POST['code'] ?? '';
$code = strtoupper(trim($code));

if ($code === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Please enter your promocode.'
    ]);
    exit;
}

try {
    // Find promo
    $stmt = $pdo->prepare("SELECT * FROM promo_codes WHERE code = ? LIMIT 1");
    $stmt->execute([$code]);
    $promo = $stmt->fetch();

    if (!$promo) {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid promocode.'
        ]);
        exit;
    }

    if ((int)$promo['is_active'] !== 1) {
        echo json_encode([
            'success' => false,
            'message' => 'This promocode is not active.'
        ]);
        exit;
    }

    if ((int)$promo['used_count'] >= (int)$promo['max_uses']) {
        echo json_encode([
            'success' => false,
            'message' => 'This promocode has reached its limit.'
        ]);
        exit;
    }

    // Increase used_count by 1
    $update = $pdo->prepare("UPDATE promo_codes SET used_count = used_count + 1 WHERE id = ?");
    $update->execute([$promo['id']]);

    echo json_encode([
        'success'   => true,
        'message'   => 'Promocode accepted.',
        'code'      => $promo['code'],
        'remaining' => max(0, (int)$promo['max_uses'] - (int)$promo['used_count'] - 1)
    ]);
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Server error. Please try again later.'
    ]);
}
