<?php
session_start();
require __DIR__ . '/config.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Fetch last 200 usages (you can change limit)
$stmt = $pdo->query("
    SELECT *
    FROM promo_usage
    ORDER BY used_at DESC
    LIMIT 200
");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Simple totals by promo
$stmt2 = $pdo->query("
    SELECT promo_code,
           COUNT(*) AS times_used,
           SUM(prize_amount) AS total_prize
    FROM promo_usage
    GROUP BY promo_code
    ORDER BY times_used DESC
    LIMIT 50
");
$summary = $stmt2->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Promo Codes View – Admin – Angpao Rain</title>
    <link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        * { box-sizing:border-box; margin:0; padding:0; }
        body {
            font-family: Arial, sans-serif;
            background:#05070a;
            color:#f1f1f1;
            display:flex;
            min-height:100vh;
        }
        .sidebar {
            width:230px;
            background:linear-gradient(180deg,#120016,#030308);
            border-right:1px solid rgba(255,255,255,0.08);
            padding:18px 12px;
            display:flex;
            flex-direction:column;
        }
        .sidebar-logo {
            display:flex;align-items:center;gap:10px;
            padding:8px 10px 18px;
            border-bottom:1px solid rgba(255,255,255,0.08);
            margin-bottom:10px;
        }
        .sidebar-logo-circle {
            width:40px;height:40px;border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            font-weight:bold;font-size:18px;color:#4a1a00;
            box-shadow:0 0 10px rgba(255,193,7,0.8);
        }
        .sidebar-logo-text {font-size:16px;font-weight:bold;}
        .sidebar-menu {margin-top:10px;list-style:none;}
        .sidebar-menu li {margin-bottom:4px;}
        .sidebar-link {
            display:flex;align-items:center;gap:10px;
            padding:9px 10px;border-radius:8px;
            color:#cbd5f5;text-decoration:none;font-size:14px;
            transition:background .15s,color .15s,transform .08s;
        }
        .sidebar-link i {width:18px;text-align:center;font-size:15px;}
        .sidebar-link:hover {
            background:rgba(255,193,7,0.16);
            color:#fff9c4;transform:translateX(2px);
        }
        .sidebar-link.active {
            background:linear-gradient(90deg,#ff9800,#f44336);
            color:#fff;box-shadow:0 0 12px rgba(255,111,0,0.8);
        }

        .main {flex:1;display:flex;flex-direction:column;}
        .topbar {
            height:56px;border-bottom:1px solid rgba(255,255,255,0.08);
            display:flex;align-items:center;justify-content:space-between;
            padding:0 20px;background:linear-gradient(90deg,#05060a,#12001b);
        }
        .topbar-left {font-size:15px;}
        .topbar-right {display:flex;align-items:center;gap:16px;font-size:14px;}
        .topbar-user {display:flex;align-items:center;gap:8px;}
        .topbar-avatar {
            width:28px;height:28px;border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            font-size:15px;color:#4a1a00;
        }
        .topbar-logout {
            color:#fca5a5;font-size:13px;text-decoration:none;
        }

        .content {padding:20px;}
        .content h1 {font-size:22px;margin-bottom:4px;}
        .content-subtitle {font-size:13px;color:#9ca3af;margin-bottom:18px;}

        .layout {
            display:grid;
            grid-template-columns:minmax(0,260px) minmax(0,1fr);
            gap:18px;
            align-items:flex-start;
        }
        .card {
            background:radial-gradient(circle at top left,#1f2933,#05070a);
            border-radius:12px;padding:14px 16px;
            border:1px solid rgba(255,255,255,0.05);
            box-shadow:0 0 10px rgba(0,0,0,0.7);
        }
        .card-title {font-size:15px;margin-bottom:8px;font-weight:bold;}

        table {
            width:100%;border-collapse:collapse;font-size:13px;
        }
        th,td {
            padding:6px 8px;
            border-bottom:1px solid rgba(156,163,175,0.35);
            text-align:left;
        }
        th {
            background:rgba(15,23,42,0.9);
            font-weight:normal;color:#e5e7eb;
        }
        tr:nth-child(even) {background:rgba(15,23,42,0.4);}
        .badge {
            display:inline-block;padding:2px 8px;
            border-radius:999px;font-size:11px;
        }
        .badge-info {
            background:rgba(59,130,246,0.2);color:#bfdbfe;
        }
    </style>
</head>
<body>

<aside class="sidebar">
    <div class="sidebar-logo">
        <div class="sidebar-logo-circle">AP</div>
        <div class="sidebar-logo-text">Angpao Admin</div>
    </div>

    <ul class="sidebar-menu">
        <li><a href="index.php" class="sidebar-link"><i class="fas fa-gauge"></i><span>Dashboard</span></a></li>
        <li><a href="win_probabilities.php" class="sidebar-link"><i class="fas fa-percentage"></i><span>Win Probabilities</span></a></li>
        <li><a href="promo_codes.php" class="sidebar-link"><i class="fas fa-ticket"></i><span>Promo Codes</span></a></li>
        <li><a href="promo_codes_view.php" class="sidebar-link active"><i class="fas fa-list-ul"></i><span>Promo Codes View</span></a></li>
        <li><a href="reports.php" class="sidebar-link"><i class="fas fa-chart-line"></i><span>Reports</span></a></li>
        <li><a href="users.php" class="sidebar-link"><i class="fas fa-users"></i><span>Users</span></a></li>
        <li><a href="config_link.php" class="sidebar-link"><i class="fas fa-link"></i><span>Config Link</span></a></li>
    </ul>
</aside>

<div class="main">
    <header class="topbar">
        <div class="topbar-left">Promo Codes View</div>
        <div class="topbar-right">
            <a href="logout.php" class="topbar-logout"><i class="fas fa-arrow-right-from-bracket"></i> Logout</a>
            <div class="topbar-user">
                <div class="topbar-avatar">A</div>
                <span><?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Admin'); ?></span>
            </div>
        </div>
    </header>

    <main class="content">
        <h1>Promo Codes Usage</h1>
        <div class="content-subtitle">
            See each time a promo code is used and how much prize was given.
        </div>

        <div class="layout">
            <!-- Summary by code -->
            <div class="card">
                <div class="card-title">
                    <i class="fas fa-layer-group" style="margin-right:4px;"></i>
                    Top Promo Codes
                </div>
                <?php if (!$summary): ?>
                    <p style="font-size:13px;color:#9ca3af;margin-top:6px;">No data yet.</p>
                <?php else: ?>
                    <table style="margin-top:6px;">
                        <thead>
                        <tr>
                            <th>Promo Code</th>
                            <th>Times Used</th>
                            <th>Total Prize</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($summary as $row): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['promo_code']); ?></td>
                                <td><?php echo (int)$row['times_used']; ?></td>
                                <td>$<?php echo (int)$row['total_prize']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>

            <!-- Last usages -->
            <div class="card">
                <div class="card-title">
                    <i class="fas fa-clock-rotate-left" style="margin-right:4px;"></i>
                    Latest Usage (Last 200)
                </div>
                <?php if (!$rows): ?>
                    <p style="font-size:13px;color:#9ca3af;margin-top:6px;">No usage yet.</p>
                <?php else: ?>
                    <div style="overflow-x:auto;margin-top:6px;max-height:500px;overflow-y:auto;">
                        <table>
                            <thead>
                            <tr>
                                <th>Time</th>
                                <th>Promo Code</th>
                                <th>Prize</th>
                                <th>IP</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($rows as $row): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['used_at']); ?></td>
                                    <td><?php echo htmlspecialchars($row['promo_code']); ?></td>
                                    <td>$<?php echo (int)$row['prize_amount']; ?></td>
                                    <td><?php echo htmlspecialchars($row['ip_address']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>

</body>
</html>
