<?php
session_start();
require __DIR__ . '/config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $password === '') {
        $error = 'Please enter username and password.';
    } else {
        $stmt = $pdo->prepare("
            SELECT id, username, password_hash, is_active
            FROM admin_users
            WHERE username = ?
            LIMIT 1
        ");
        $stmt->execute([$username]);
        $admin = $stmt->fetch();

        if ($admin && password_verify($password, $admin['password_hash'])) {

            if ((int)$admin['is_active'] !== 1) {
                $error = 'This admin account is inactive.';
            } else {
                // Update last_login_at
                $stmtUpd = $pdo->prepare("UPDATE admin_users SET last_login_at = NOW() WHERE id = ?");
                $stmtUpd->execute([$admin['id']]);

                // Login success
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_username'] = $admin['username'];

                header('Location: index.php');
                exit;
            }

        } else {
            $error = 'Invalid username or password.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login – Angpao Rain</title>
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
          crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        *{box-sizing:border-box;margin:0;padding:0}
        body{
            font-family:Arial,sans-serif;
            min-height:100vh;
            display:flex;
            align-items:center;
            justify-content:center;
            background:radial-gradient(circle at top,#2b0007,#050308 60%,#000 100%);
            color:#f9fafb;
        }
        .login-card{
            width:320px;
            background:rgba(10,10,15,0.92);
            border-radius:16px;
            padding:24px 26px 22px;
            box-shadow:0 0 24px rgba(0,0,0,0.9);
            border:1px solid rgba(255,255,255,0.08);
        }
        .login-logo{
            width:70px;height:70px;
            border-radius:999px;
            margin:0 auto 10px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            font-weight:bold;font-size:22px;color:#4a1a00;
            box-shadow:0 0 14px rgba(255,193,7,0.9);
        }
        .login-title{
            text-align:center;
            font-size:18px;
            margin-bottom:4px;
        }
        .login-subtitle{
            text-align:center;
            font-size:12px;
            color:#9ca3af;
            margin-bottom:16px;
        }
        .field-label{
            font-size:13px;
            margin-bottom:4px;
        }
        .field{
            margin-bottom:14px;
        }
        .input{
            width:100%;
            padding:9px 10px;
            border-radius:8px;
            border:none;
            outline:none;
            font-size:14px;
            background:#111827;
            color:#f9fafb;
        }
        .input:focus{
            box-shadow:0 0 0 1px #fbbf24;
        }
        .btn-login{
            width:100%;
            padding:9px;
            border-radius:999px;
            border:none;
            outline:none;
            cursor:pointer;
            font-size:14px;
            font-weight:bold;
            background:linear-gradient(135deg,#ff9800,#f43f5e);
            color:#fff;
            box-shadow:0 0 14px rgba(248,113,113,0.7);
            margin-top:4px;
        }
        .btn-login:hover{
            filter:brightness(1.05);
        }
        .error{
            color:#f87171;
            font-size:12px;
            text-align:center;
            min-height:16px;
            margin-bottom:6px;
        }
        .footer{
            text-align:center;
            margin-top:10px;
            font-size:11px;
            color:#6b7280;
        }
    </style>
</head>
<body>

<div class="login-card">
    <div class="login-logo">
        AP
    </div>
    <div class="login-title">Admin Login</div>
    <div class="login-subtitle">Angpao Rain Control Panel</div>

    <?php if ($error): ?>
        <div class="error"><?php echo htmlspecialchars($error); ?></div>
    <?php else: ?>
        <div class="error"></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
        <div class="field">
            <div class="field-label">Username</div>
            <input class="input" type="text" name="username" required>
        </div>
        <div class="field">
            <div class="field-label">Password</div>
            <input class="input" type="password" name="password" required>
        </div>
        <button class="btn-login" type="submit">
            <i class="fas fa-right-to-bracket" style="margin-right:6px;"></i> Login
        </button>
    </form>

    <div class="footer">
        &copy; <?php echo date('Y'); ?> Angpao Rain
    </div>
</div>

</body>
</html>
