<?php
session_start();
require __DIR__ . '/config.php';

// Protect page
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// === BASIC STATS ===

// Promo codes
$promoStats = $pdo->query("
    SELECT
        COUNT(*) AS total_codes,
        SUM(CASE WHEN is_active = 1 THEN 1 ELSE 0 END) AS active_codes
    FROM promo_codes
")->fetch(PDO::FETCH_ASSOC);

// Usage stats
$usageTotal = $pdo->query("
    SELECT
        COUNT(*) AS total_plays,
        SUM(prize_amount) AS total_prize
    FROM promo_usage
")->fetch(PDO::FETCH_ASSOC);

// Today stats
$usageToday = $pdo->query("
    SELECT
        COUNT(*) AS plays_today,
        SUM(prize_amount) AS prize_today
    FROM promo_usage
    WHERE DATE(used_at) = CURDATE()
")->fetch(PDO::FETCH_ASSOC);

// Prize distribution (for small chart-style table)
$prizeDist = $pdo->query("
    SELECT prize_amount, COUNT(*) AS times
    FROM promo_usage
    GROUP BY prize_amount
    ORDER BY prize_amount ASC
")->fetchAll(PDO::FETCH_ASSOC);

// Last 10 plays
$recentPlays = $pdo->query("
    SELECT promo_code, prize_amount, used_at, ip_address
    FROM promo_usage
    ORDER BY used_at DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard – Admin – Angpao Rain</title>
    <link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        * { box-sizing:border-box; margin:0; padding:0; }
        body {
            font-family: Arial, sans-serif;
            background:#05070a;
            color:#f1f1f1;
            display:flex;
            min-height:100vh;
        }

        i {
            font-family: "Font Awesome 6 Free" !important;
            font-weight: 900 !important;
        }

        /* ===== SIDEBAR (same style as other pages) ===== */
        .sidebar {
            width:230px;
            background:linear-gradient(180deg,#120016,#030308);
            border-right:1px solid rgba(255,255,255,0.08);
            padding:18px 12px;
            display:flex;
            flex-direction:column;
        }
        .sidebar-logo {
            display:flex;align-items:center;gap:10px;
            padding:8px 10px 18px;
            border-bottom:1px solid rgba(255,255,255,0.08);
            margin-bottom:10px;
        }
        .sidebar-logo-circle {
            width:40px;height:40px;border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            color:#4a1a00;font-weight:bold;font-size:18px;
            box-shadow:0 0 10px rgba(255,193,7,0.8);
        }
        .sidebar-logo-text {font-size:16px;font-weight:bold;letter-spacing:1px;}
        .sidebar-menu {margin-top:10px;list-style:none;}
        .sidebar-menu li {margin-bottom:4px;}
        .sidebar-link {
            display:flex;align-items:center;gap:10px;
            padding:9px 10px;border-radius:8px;
            color:#cbd5f5;text-decoration:none;font-size:14px;
            transition:background .15s,color .15s,transform .08s;
        }
        .sidebar-link i {
            width:18px;text-align:center;font-size:15px;
        }
        .sidebar-link:hover {
            background:rgba(255,193,7,0.16);
            color:#fff9c4;transform:translateX(2px);
        }
        .sidebar-link.active {
            background:linear-gradient(90deg,#ff9800,#f44336);
            color:#ffffff;
            box-shadow:0 0 12px rgba(255,111,0,0.8);
        }

        /* ===== MAIN LAYOUT ===== */
        .main {flex:1;display:flex;flex-direction:column;}

        .topbar {
            height:56px;
            border-bottom:1px solid rgba(255,255,255,0.08);
            display:flex;align-items:center;justify-content:space-between;
            padding:0 20px;
            background:linear-gradient(90deg,#05060a,#12001b);
        }
        .topbar-left {font-size:15px;color:#e5e7eb;}
        .topbar-right {display:flex;align-items:center;gap:16px;font-size:14px;}
        .topbar-logout {color:#fca5a5;font-size:13px;text-decoration:none;}
        .topbar-user {display:flex;align-items:center;gap:8px;}
        .topbar-avatar {
            width:28px;height:28px;border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            font-size:15px;color:#4a1a00;
        }

        .content {padding:20px;}
        .content h1 {font-size:22px;margin-bottom:4px;}
        .content-subtitle {font-size:13px;color:#9ca3af;margin-bottom:18px;}

        /* Cards row */
        .cards {
            display:grid;
            grid-template-columns:repeat(auto-fit,minmax(190px,1fr));
            gap:14px;
            margin-bottom:18px;
        }
        .card-small {
            background:radial-gradient(circle at top left,#1f2933,#05070a);
            border-radius:12px;
            padding:12px 14px;
            border:1px solid rgba(255,255,255,0.05);
            box-shadow:0 0 10px rgba(0,0,0,0.7);
        }
        .card-small-title {font-size:12px;color:#9ca3af;margin-bottom:4px;}
        .card-small-value {font-size:20px;font-weight:bold;}
        .card-small-sub {font-size:11px;color:#9ca3af;margin-top:2px;}

        .layout {
            display:grid;
            grid-template-columns:minmax(0,1.1fr) minmax(0,0.9fr);
            gap:18px;
            align-items:flex-start;
        }
        .card {
            background:radial-gradient(circle at top left,#1f2933,#05070a);
            border-radius:12px;
            padding:14px 16px;
            border:1px solid rgba(255,255,255,0.05);
            box-shadow:0 0 10px rgba(0,0,0,0.7);
        }
        .card-title {font-size:15px;margin-bottom:8px;font-weight:bold;}

        table {
            width:100%;border-collapse:collapse;font-size:12px;
        }
        th,td {
            padding:6px 8px;
            border-bottom:1px solid rgba(156,163,175,0.35);
            text-align:left;
        }
        th {
            background:rgba(15,23,42,0.9);
            font-weight:normal;color:#e5e7eb;
        }
        tr:nth-child(even) {background:rgba(15,23,42,0.5);}
    </style>
</head>
<body>

<!-- SIDEBAR -->
<aside class="sidebar">
    <div class="sidebar-logo">
        <div class="sidebar-logo-circle">AP</div>
        <div class="sidebar-logo-text">Angpao Admin</div>
    </div>

    <ul class="sidebar-menu">
    <li>
        <a href="index.php" class="sidebar-link active">
            <i class="fa-solid fa-gauge"></i>
            <span>Dashboard</span>
        </a>
    </li>
    <li>
        <a href="win_probabilities.php" class="sidebar-link">
            <i class="fa-solid fa-percent"></i>
            <span>Win Probabilities</span>
        </a>
    </li>
    <li>
        <a href="promo_codes.php" class="sidebar-link">
            <i class="fa-solid fa-ticket"></i>
            <span>Promo Codes</span>
        </a>
    </li>
    <li>
        <a href="promo_codes_view.php" class="sidebar-link">
            <i class="fa-solid fa-list-ul"></i>
            <span>Promo Codes View</span>
        </a>
    </li>
    <li>
        <a href="reports.php" class="sidebar-link">
            <i class="fa-solid fa-chart-line"></i>
            <span>Reports</span>
        </a>
    </li>
    <li>
        <a href="users.php" class="sidebar-link">
            <i class="fa-solid fa-users"></i>
            <span>Users</span>
        </a>
    </li>
    <li>
        <a href="config_link.php" class="sidebar-link">
            <i class="fa-solid fa-link"></i>
            <span>Config Link</span>
        </a>
    </li>
</ul>

</aside>

<!-- MAIN -->
<div class="main">
    <header class="topbar">
        <div class="topbar-left">Dashboard</div>
        <div class="topbar-right">
            <a href="logout.php" class="topbar-logout">
                <i class="fas fa-arrow-right-from-bracket"></i> Logout
            </a>
            <div class="topbar-user">
                <div class="topbar-avatar">A</div>
                <span><?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Admin'); ?></span>
            </div>
        </div>
    </header>

    <main class="content">
        <h1>Welcome back 👋</h1>
        <div class="content-subtitle">
            Quick overview of your Angpao Rain promotion performance.
        </div>

        <!-- Top summary cards -->
        <div class="cards">
            <div class="card-small">
                <div class="card-small-title">Total Promo Codes</div>
                <div class="card-small-value">
                    <?php echo (int)($promoStats['total_codes'] ?? 0); ?>
                </div>
                <div class="card-small-sub">
                    Active: <?php echo (int)($promoStats['active_codes'] ?? 0); ?>
                </div>
            </div>

            <div class="card-small">
                <div class="card-small-title">Total Games Played</div>
                <div class="card-small-value">
                    <?php echo (int)($usageTotal['total_plays'] ?? 0); ?>
                </div>
                <div class="card-small-sub">
                    Since start
                </div>
            </div>

            <div class="card-small">
                <div class="card-small-title">Total Prize Given</div>
                <div class="card-small-value">
                    $<?php echo (int)($usageTotal['total_prize'] ?? 0); ?>
                </div>
                <div class="card-small-sub">
                    All promotions
                </div>
            </div>

            <div class="card-small">
                <div class="card-small-title">Today</div>
                <div class="card-small-value">
                    <?php echo (int)($usageToday['plays_today'] ?? 0); ?> plays
                </div>
                <div class="card-small-sub">
                    Prize today: $<?php echo (int)($usageToday['prize_today'] ?? 0); ?>
                </div>
            </div>
        </div>

        <!-- Bottom layout -->
        <div class="layout">
            <!-- Left: recent plays -->
            <div class="card">
                <div class="card-title">
                    <i class="fas fa-clock-rotate-left" style="margin-right:4px;"></i>
                    Latest Plays
                </div>
                <?php if (empty($recentPlays)): ?>
                    <p style="font-size:13px;color:#9ca3af;margin-top:6px;">
                        No games played yet.
                    </p>
                <?php else: ?>
                    <div style="overflow-x:auto;margin-top:6px;">
                        <table>
                            <thead>
                            <tr>
                                <th>Time</th>
                                <th>Promo Code</th>
                                <th>Prize</th>
                                <th>IP</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($recentPlays as $row): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['used_at']); ?></td>
                                    <td><?php echo htmlspecialchars($row['promo_code']); ?></td>
                                    <td>$<?php echo (int)$row['prize_amount']; ?></td>
                                    <td><?php echo htmlspecialchars($row['ip_address']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Right: prize distribution -->
            <div class="card">
                <div class="card-title">
                    <i class="fas fa-coins" style="margin-right:4px;"></i>
                    Prize Distribution
                </div>
                <?php if (empty($prizeDist)): ?>
                    <p style="font-size:13px;color:#9ca3af;margin-top:6px;">
                        No prize data yet.
                    </p>
                <?php else: ?>
                    <table style="margin-top:6px;">
                        <thead>
                        <tr>
                            <th>Prize</th>
                            <th>Times</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($prizeDist as $row): ?>
                            <tr>
                                <td>$<?php echo (int)$row['prize_amount']; ?></td>
                                <td><?php echo (int)$row['times']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>

</body>
</html>
