<?php
session_start();
require __DIR__ . '/config.php';

// Protect page
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$error = '';
$success = '';

// Load current config (id = 1)
$stmt = $pdo->prepare("SELECT * FROM site_config WHERE id = 1 LIMIT 1");
$stmt->execute();
$config = $stmt->fetch(PDO::FETCH_ASSOC);

// If row somehow missing, create it
if (!$config) {
    $pdo->exec("INSERT INTO site_config (id) VALUES (1)");
    $stmt = $pdo->prepare("SELECT * FROM site_config WHERE id = 1 LIMIT 1");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Read success from URL (after redirect)
if (isset($_GET['success'])) {
    $success = $_GET['success'];
}

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_config'])) {
    $site_name         = trim($_POST['site_name'] ?? '');
    $front_game_url    = trim($_POST['front_game_url'] ?? '');
    $logo_url          = trim($_POST['logo_url'] ?? '');
    $promo_help_text   = trim($_POST['promo_help_text'] ?? '');
    $claim_prize_url   = trim($_POST['claim_prize_url'] ?? '');
    $maintenance_mode  = isset($_POST['maintenance_mode']) ? 1 : 0;
    $maintenance_msg   = trim($_POST['maintenance_message'] ?? '');

    if ($site_name === '') {
        $error = 'Site name is required.';
    } else {
        $stmtUp = $pdo->prepare("
            UPDATE site_config
            SET site_name = ?,
                front_game_url = ?,
                logo_url = ?,
                promo_help_text = ?,
                claim_prize_url = ?,
                maintenance_mode = ?,
                maintenance_message = ?
            WHERE id = 1
        ");

        try {
            $stmtUp->execute([
                $site_name,
                $front_game_url,
                $logo_url,
                $promo_help_text,
                $claim_prize_url,
                $maintenance_mode,
                $maintenance_msg
            ]);

            $msg = 'Configuration saved successfully.';
            header("Location: config_link.php?success=" . urlencode($msg));
            exit;

        } catch (PDOException $e) {
            $error = 'Error saving configuration.';
        }
    }

    // Reload config for form in case of error
    $stmt = $pdo->prepare("SELECT * FROM site_config WHERE id = 1 LIMIT 1");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Config Link – Admin – Angpao Rain</title>
    <link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        * { box-sizing:border-box; margin:0; padding:0; }

        body {
            font-family: Arial, sans-serif;
            background: #05070a;
            color: #f1f1f1;
            display: flex;
            min-height: 100vh;
        }

        /* ===== SIDEBAR ===== */
        .sidebar {
            width: 230px;
            background: linear-gradient(180deg, #120016, #030308);
            border-right: 1px solid rgba(255,255,255,0.08);
            padding: 18px 12px;
            display: flex;
            flex-direction: column;
        }

        .sidebar-logo {
            display:flex;
            align-items:center;
            gap:10px;
            padding:8px 10px 18px;
            border-bottom:1px solid rgba(255,255,255,0.08);
            margin-bottom:10px;
        }

        .sidebar-logo-circle {
            width:40px;height:40px;
            border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            color:#4a1a00;font-weight:bold;font-size:18px;
            box-shadow:0 0 10px rgba(255,193,7,0.8);
        }

        .sidebar-logo-text {
            font-size:16px;
            font-weight:bold;
            letter-spacing:1px;
        }

        .sidebar-menu { margin-top:10px; list-style:none; }
        .sidebar-menu li { margin-bottom:4px; }

        .sidebar-link {
            display:flex;align-items:center;gap:10px;
            padding:9px 10px;
            border-radius:8px;
            color:#cbd5f5;
            text-decoration:none;
            font-size:14px;
            transition:background 0.15s,color 0.15s,transform 0.08s;
        }

        .sidebar-link i {
            width:18px;text-align:center;font-size:15px;
        }

        .sidebar-link:hover {
            background:rgba(255,193,7,0.16);
            color:#fff9c4;
            transform:translateX(2px);
        }

        .sidebar-link.active {
            background:linear-gradient(90deg,#ff9800,#f44336);
            color:#ffffff;
            box-shadow:0 0 12px rgba(255,111,0,0.8);
        }

        /* ===== MAIN ===== */
        .main {
            flex:1;
            display:flex;
            flex-direction:column;
        }

        .topbar {
            height:56px;
            border-bottom:1px solid rgba(255,255,255,0.08);
            display:flex;
            align-items:center;
            justify-content:space-between;
            padding:0 20px;
            background:linear-gradient(90deg,#05060a,#12001b);
        }

        .topbar-left { font-size:15px;color:#e5e7eb; }
        .topbar-right { display:flex;align-items:center;gap:16px;font-size:14px; }
        .topbar-logout { color:#fca5a5;font-size:13px;text-decoration:none; }
        .topbar-user { display:flex;align-items:center;gap:8px; }

        .topbar-avatar {
            width:28px;height:28px;
            border-radius:999px;
            background:radial-gradient(circle,#ffeb3b,#ff9800);
            display:flex;align-items:center;justify-content:center;
            font-size:15px;color:#4a1a00;
        }

        .content { padding:20px; }
        .content h1 { font-size:22px;margin-bottom:4px; }
        .content-subtitle { font-size:13px;color:#9ca3af;margin-bottom:18px; }

        .card {
            background:radial-gradient(circle at top left,#1f2933,#05070a);
            border-radius:12px;
            padding:16px 18px;
            border:1px solid rgba(255,255,255,0.05);
            box-shadow:0 0 10px rgba(0,0,0,0.7);
            max-width:540px;
        }

        .card-title {
            font-size:14px;
            margin-bottom:10px;
            font-weight:bold;
        }

        .field { margin-bottom:12px; }

        .field label {
            display:block;
            font-size:12px;
            margin-bottom:4px;
            color:#d1d5db;
        }

        .input, .textarea {
            width:100%;
            padding:8px 9px;
            border-radius:8px;
            border:none;
            outline:none;
            background:#111827;
            color:#f9fafb;
            font-size:13px;
        }

        .input:focus, .textarea:focus {
            box-shadow:0 0 0 1px #fbbf24;
        }

        .textarea { resize:vertical;min-height:60px; }

        .checkbox-row {
            display:flex;
            align-items:center;
            gap:6px;
            font-size:13px;
        }

        .btn {
            padding:8px 16px;
            border-radius:999px;
            border:none;
            outline:none;
            cursor:pointer;
            font-size:13px;
            font-weight:bold;
            background:linear-gradient(135deg,#ff9800,#f43f5e);
            color:#fff;
            box-shadow:0 0 10px rgba(248,113,113,0.7);
        }

        .status-msg { font-size:12px;min-height:16px;margin-bottom:8px; }
        .status-success { color:#6ee7b7; }
        .status-error   { color:#f87171; }

        .small-hint {
            font-size:11px;
            color:#9ca3af;
            margin-top:2px;
        }
    </style>
</head>
<body>

<!-- SIDEBAR -->
<aside class="sidebar">
    <div class="sidebar-logo">
        <div class="sidebar-logo-circle">AP</div>
        <div class="sidebar-logo-text">Angpao Admin</div>
    </div>

    <ul class="sidebar-menu">
        <li><a href="index.php" class="sidebar-link"><i class="fas fa-gauge"></i><span>Dashboard</span></a></li>
        <li><a href="win_probabilities.php" class="sidebar-link"><i class="fas fa-percentage"></i><span>Win Probabilities</span></a></li>
        <li><a href="promo_codes.php" class="sidebar-link"><i class="fas fa-ticket"></i><span>Promo Codes</span></a></li>
        <li><a href="promo_codes_view.php" class="sidebar-link"><i class="fas fa-list-ul"></i><span>Promo Codes View</span></a></li>
        <li><a href="reports.php" class="sidebar-link"><i class="fas fa-chart-line"></i><span>Reports</span></a></li>
        <li><a href="users.php" class="sidebar-link"><i class="fas fa-users"></i><span>Users</span></a></li>
        <li><a href="config_link.php" class="sidebar-link active"><i class="fas fa-link"></i><span>Config Link</span></a></li>
    </ul>
</aside>

<!-- MAIN -->
<div class="main">
    <header class="topbar">
        <div class="topbar-left">Config Link</div>
        <div class="topbar-right">
            <a href="logout.php" class="topbar-logout">
                <i class="fas fa-arrow-right-from-bracket"></i> Logout
            </a>
            <div class="topbar-user">
                <div class="topbar-avatar">A</div>
                <span><?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Admin'); ?></span>
            </div>
        </div>
    </header>

    <main class="content">
        <h1>Site & Game Configuration</h1>
        <div class="content-subtitle">
            Control links and basic settings used by the Angpao Rain game.
        </div>

        <div class="card">
            <div class="card-title">
                <i class="fas fa-link" style="margin-right:4px;"></i> Basic Settings
            </div>

            <div class="status-msg">
                <?php if ($success): ?>
                    <span class="status-success"><?php echo htmlspecialchars($success); ?></span>
                <?php elseif ($error): ?>
                    <span class="status-error"><?php echo htmlspecialchars($error); ?></span>
                <?php endif; ?>
            </div>

            <form method="post">
                <div class="field">
                    <label for="site_name">Site / Panel Name</label>
                    <input class="input" type="text" id="site_name" name="site_name"
                           value="<?php echo htmlspecialchars($config['site_name'] ?? 'Angpao Rain'); ?>" required>
                    <div class="small-hint">Shown in admin header or title.</div>
                </div>

                <div class="field">
                    <label for="front_game_url">Front Game URL</label>
                    <input class="input" type="text" id="front_game_url" name="front_game_url"
                           placeholder="https://yourdomain.com/angpao/index.php"
                           value="<?php echo htmlspecialchars($config['front_game_url'] ?? ''); ?>">
                    <div class="small-hint">Where the Angpao Rain game is hosted.</div>
                </div>

                <div class="field">
                    <label for="logo_url">Logo URL</label>
                    <input class="input" type="text" id="logo_url" name="logo_url"
                           placeholder="https://yourdomain.com/logo.jpg"
                           value="<?php echo htmlspecialchars($config['logo_url'] ?? ''); ?>">
                    <div class="small-hint">Later we can use this on the frontend game and admin.</div>
                </div>

                <div class="field">
                    <label for="claim_prize_url">Claim Prize URL</label>
                    <input class="input" type="text" id="claim_prize_url" name="claim_prize_url"
                        placeholder="https://yourdomain.com"
                        value="<?php echo htmlspecialchars($config['claim_prize_url'] ?? ''); ?>">
                    <div class="small-hint">
                        User will go to this link after clicking "Claim your Prize".
                    </div>
                </div>

                <div class="field">
                    <label for="promo_help_text">Promo Help Text</label>
                    <input class="input" type="text" id="promo_help_text" name="promo_help_text"
                           placeholder="Please fill your promocode to start this game"
                           value="<?php echo htmlspecialchars($config['promo_help_text'] ?? ''); ?>">
                    <div class="small-hint">
                        Text displayed near promocode input on game page (we’ll connect later).
                    </div>
                </div>

                <div class="field">
                    <label>Maintenance Mode</label>
                    <div class="checkbox-row">
                        <input type="checkbox" id="maintenance_mode" name="maintenance_mode"
                               <?php echo !empty($config['maintenance_mode']) ? 'checked' : ''; ?>>
                        <label for="maintenance_mode" style="margin:0;">Enable maintenance mode</label>
                    </div>
                    <div class="small-hint">
                        Later we can block game and show message if maintenance is ON.
                    </div>
                </div>

                <div class="field">
                    <label for="maintenance_message">Maintenance Message</label>
                    <textarea class="textarea" id="maintenance_message" name="maintenance_message"
                              placeholder="Game is under maintenance, please try again later."><?php
                        echo htmlspecialchars($config['maintenance_message'] ?? '');
                    ?></textarea>
                </div>

                <button type="submit" class="btn" name="save_config" value="1">
                    <i class="fas fa-save" style="margin-right:4px;"></i> Save Config
                </button>
            </form>
        </div>
    </main>
</div>

</body>
</html>
