<?php
// admin.php
require 'config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $prize_options = trim($_POST['prize_options'] ?? '');

    if ($prize_options === '') {
        $message = "Please enter at least one value.";
    } else {
        // Save to DB (id = 1 fixed)
        $stmt = $pdo->prepare("REPLACE INTO angpao_settings (id, prize_options) VALUES (1, :prize_options)");
        $stmt->execute(['prize_options' => $prize_options]);
        $message = "Angpao prize options updated!";
    }
}

// Get current value
$stmt = $pdo->query("SELECT prize_options FROM angpao_settings WHERE id = 1");
$current = $stmt->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Angpao Admin</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        input[type=text] { width: 300px; padding: 6px; }
        button { padding: 6px 12px; cursor: pointer; }
        .msg { margin-top: 10px; color: green; }
    </style>
</head>
<body>
    <h1>Angpao Backend Settings</h1>
    <form method="post">
        <label>Prize values (comma separated):</label><br>
        <input type="text" name="prize_options"
               value="<?= htmlspecialchars($current ?: '1,2,5,10,20,50') ?>">
        <button type="submit">Save</button>
    </form>

    <?php if ($message): ?>
        <div class="msg"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <p>Example: <code>1,2,5,10,20,50</code> or <code>1,1,2,5</code> (you can repeat numbers to increase chances).</p>
</body>
</html>
